﻿
CREATE PROCEDURE [App].[NVCC_usp_UserCounts]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_UserCounts
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-02-2016
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert to use NVCC_UsersV2 and NVCC_ProductionLog.
--                        Drop LoggedUsers.
--
--Purpose               : Various counts of users
--==================================================================================
--Uses: App.NVCC_UsersV2
--Uses: App.NVCC_ProductionLog
--Uses: App.NVCC_udf_ActiveUserCount()

SELECT
	T.LookedUsers,
	0 AS LoggedUsers, -- Used to be the number of users who had generated a logged entry, but expensive to calculate and not useful because poorly defined
	R.RDPUsers,
	A.ActiveUsers,
	A.ActiveSites
FROM
	(
		SELECT COUNT(*) AS LookedUsers
		FROM App.NVCC_UsersV2
	) AS T
	CROSS JOIN
	(
		SELECT COUNT(DISTINCT UserID) AS RDPUsers
		FROM App.NVCC_ProductionLog
	) AS R
	CROSS JOIN
	(
		SELECT
			SUM(ActiveUsers) AS ActiveUsers,
			COUNT(*) AS ActiveSites
		FROM App.NVCC_udf_ActiveUserCount()
	) AS A
